const slugify = require('slugify');

let loaded = false;
document.addEventListener("readystatechange", () => {
    function listenForm() {
        $('.modal section').each(function (key) {
            let section = $(this);

            $('[name="section' + (key + 1) + '-type"]').change(function (e) {
                let regex;
                if (e.target.value === 'liste') {
                    regex = new RegExp('^section' + (key + 1) + '-lien');
                } else {
                    regex = new RegExp('^section' + (key + 1) + '-liste');
                }
                section.find('input,select,textarea').each(function() {
                    this.disabled = this.name.match(regex);
                    if (this.dataset.toggle == 'ckeditor' && CKEDITOR != undefined) {
                        CKEDITOR.instances[this.name].setReadOnly(e.target.value === 'liste');
                    }
                    if (this.classList.contains('color-picker') && this.disabled) {
                        $('[for="' + this.id + '"].control-label').parent().addClass('disabled');
                    } else {
                        $('[for="' + this.id + '"].control-label').parent().removeClass('disabled');
                    }
                });
            });
        });
    }

    if (!loaded) {
        loaded = true;
        $('.choix-sommaire a').click(function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            let el = $(this), route = el.data('toload'), titleModal = el.data('title');
            axios.get(route).then((response) => {
                $('#whatEverModalLabel').text(titleModal);
                $('.modal-body').html(response.data)
                $('.modal').modal();
                listenForm();
            });
        });
        
        $(document).on('edit-sommaire', function(e) {
            axios.get(e.detail.route).then((response) => {
                $('.modal-body').html(response.data)
                $('.modal').modal();
                listenForm();
            });
        })

        $('.modal').delegate('#titre', 'input', function (e) {
            $('#slug').val(slugify(e.target.value, {
                strict: true,
                remove: /\s[!.?]/g
            }));
        });
    }
});