<?php


namespace Tests\Feature;


use Bloom\CMS\Modules\Architecture\Database\Relation\BelongsToPage;
use Bloom\CMS\Modules\Architecture\Database\Relation\HasExtendedRelationships;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Routing\Controller;

/**
 * Class Contenu
 * @package Tests\Unit
 *
 * @property Page $page
 */
class Contenu extends Model implements \Bloom\CMS\Modules\Architecture\Model\Contenu
{
    use HasExtendedRelationships;
    protected $guarded = [];

    public function page(): BelongsToPage
    {
        return $this->belongsToPage();
    }

    public function getHandler(): ContenuHandler
    {
        return new class extends Controller implements ContenuHandler {
            public function single(\Bloom\CMS\Modules\Architecture\Model\Contenu $contenu)
            {
                return \response([
                    "status" => true
                ]);
            }

            public function multiple(Collection $contenus)
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }
        };
    }
}
