import {defineConfig} from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';

export default defineConfig({
  plugins: [
    laravel([
      'resources/js/listing.js'
    ]),
    vue(),
  ],
  build: {
    rollupOptions: {
      input: {
        listing: 'resources/js/listing.js',
        sectionInfo: 'resources/js/sectionInfo.js'
      },
      external: ['vue'],
      output: {
        globals: {
          vue: 'Vue',
        },
        entryFileNames: (chunkInfo) => {
          return `[name]-[hash].[format].js`;
        },
        dir: 'public/build/assets'
      },
    },
  },
});