@extends('bloom.layout.default')

@section('content')
    <section class="wrapper-content pb-0">
        <div class="container">
            <h1>{{ $page->titre }}</h1>

            @if(!(is_null($page->intro)) && !(empty($page->intro)))
                <div class="exergue mb-50">
                    {!! $page->intro !!}
                </div>
            @endif

            @if(isset($page->image_opengraph))
                <img src="{{ $page->image_opengraph }}" alt="" class="img-fluid w-100">
            @endif
        </div>
    </section>

    <section class="b-gris7">
        <div class="container">
            <ul class="list-unstyled list-repertoire row">
                @foreach($sections as $section)
                    @if($section->type === 'liste')
                        <li class="col-md-4">
                            <h2 class="mt-0">{{ $section->titre }}</h2>
                            <ul class="list-unstyled list-custom-arrow list-bleu mb-0">
                                @foreach($section->info->pages as $lien)
                                    <li @if($loop->first) class="mt-0" @endif>
                                        <a href="{{ $lien->pathname }}">
                                            {{ $lien->titre }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                    @else
                        <li class="col-md-4">
                            <div class="exergue">
                                <h3>{{ $section->titre }}</h3>
                                <div class="desc">
                                    {!! $section->info->description !!}
                                </div>
                                <a href="{{ $section->info->$page->pathname }}"
                                   style="background-color: {{ $section->info->cta_bg }};color: {{ $section->info->cta_color }}"
                                   class="btn btn-bleu mt-4 w-auto"
                                >
                                    {{ $section->info->cta }}
                                </a>
                            </div>
                        </li>
                    @endif
                @endforeach
            </ul>
        </div>
    </section>

    @if(count($page->mentions) > 0)
        <section class="mentions b-gris7">
            <div class="container">
                <p>
                    <strong>Mentions</strong>
                </p>

                <div class="content">
                    {!! $page->mentions !!}
                </div>
            </div>
        </section>
    @endif
@endsection