@extends('bloom.layout.default')

@section('content')
    <section class="wrapper-content pb-0">
        <div class="container">
            <h1>{{ $page->titre }}</h1>

            @if(!(is_null($page->intro)) && !(empty($page->intro)))
                <div class="exergue mb-50">
                    {!! $page->intro !!}
                </div>
            @endif

            @if(isset($page->image_opengraph))
                <img src="{{ $page->image_opengraph }}" alt="" class="img-fluid w-100">
            @endif
        </div>
    </section>

    <section class="b-gris7">
        <div class="container">
            <ul class="list-unstyled list-repertoire row">
                <li class="col-md-4">
                    <ul class="list-unstyled list-custom-arrow list-bleu mb-0">
                        @foreach($pages as $p)
                            <li @if($loop->first) class="mt-0" @endif>
                                <a href="{{ $p->pathname }}">{{ $p->titre }}</a>
                            </li>
                        @endforeach
                    </ul>
                </li>
                @if(count($dossier->pages()->published()) > 0)
                    @foreach($page->dossier->childs as $dossier)
                        <li class="col-md-4">
                            <h2 class="mt-0"><a href="{{ $dossier->full_pathname }}">{{ $dossier->name }}</a></h2>
                        </li>
                    @endforeach
                @endif
            </ul>
        </div>
    </section>

    @if(count($page->mentions) > 0)
        <section class="mentions b-gris7">
            <div class="container">
                <p>
                    <strong>Mentions</strong>
                </p>

                <div class="content">
                    {!! $page->mentions !!}
                </div>
            </div>
        </section>
    @endif
@endsection