<form action="{{ route('admin_archi_save_statique', $page) }}" method="post" id="form">
    {{ csrf_field() }}

    <div class="form-group row mb-0">
        <div class="col-6 mb-4">
            <x-forms.input-text
                    name="titre"
                    text="Titre"
                    :value="$page->titre ?? ''"
                    form="admin"
            />
        </div>
        <div class="col-6 mb-4">
            <x-forms.input-text
                    name="slug"
                    text="Slug"
                    :value="$page->slug ?? ''"
                    form="admin"
            />
        </div>

        <div class="col-12 mb-4">
            <div class="wrapper-editor">
                <x-forms.editor
                        name="intro"
                        text="Introduction <em>(facultatif)</em>"
                        :value="$page->intro ?? ''"
                        form="admin"
                        format="mini"
                />
            </div>
        </div>

        <div class="col-12 mb-4">
            <label for="image" class="control-label">Image</label>
            <x-forms.input-custom-file-with-image
                    name="vignette"
                    text="Parcourir"
                    form="admin"
                    :required="true"
                    :value="$page->image_opengraph ?? ''"
            />
        </div>

        <div class="col-12 mb-4">
            <div class="wrapper-editor">
                <x-forms.editor
                        name="mentions"
                        text="Mentions <em>(facultatif)</em>"
                        :value="$page->mentions ?? ''"
                        form="admin"
                        format="mini"
                />
            </div>
        </div>
    </div>

    <div class="wrapper-btn justify-content-center">
        <button class="btn-annuler btn btn-secondary mx-2" type="button" data-dismiss="modal">Annuler</button>
        <button class="btn-valider btn btn-grisclair5 btn-primary mx-2" type="submit">Valider</button>
    </div>
</form>
