<script>
  window.Dossiers = {!! $dossiers !!};
  window.Pages = {!! $pages !!};
  window.Sections = {!! $sections !!};
  window.SelectPages = {!! $selectPages !!};
</script>

<form action="{{ route('admin_archi_perso_save', $page) }}" method="post" id="form" class="sections">
    {{ csrf_field() }}

    <div class="form-group row mb-0">
        <div class="col-6 mb-4">
            <x-forms.input-text
                    name="titre"
                    text="Titre"
                    :value="isset($page) ? $page->titre : ''"
                    form="admin"
            />
        </div>
        <div class="col-6 mb-4">
            <x-forms.input-text
                    name="slug"
                    text="Slug"
                    :value="isset($page) && isset($page->dossier->slug) ? $page->dossier->slug : ''"
                    form="admin"
            />
        </div>

        <div class="col-12 mb-4">
            <div class="wrapper-editor">
                <x-forms.editor
                        name="intro"
                        text="Introduction <em>(facultatif)</em>"
                        :value="isset($page) ? $page->intro : ''"
                        form="admin"
                        format="mini"
                />
            </div>
        </div>

        <div class="col-12 mb-4">
            <label for="image" class="control-label">Image (Largeur max : 1140px)</label>
            <x-forms.input-custom-file-with-image
                    name="vignette"
                    text="Parcourir"
                    form="admin"
                    :required="true"
                    :value="isset($page) ? $page->image_opengraph : ''"
            />
        </div>

        <section-info :key="section.id" :rang="section.rang" :last="section.rang === sections.length"
                      v-for="section in sections" :form="section" @remove-section="removeSection" @rank-up="rankUp"
                      @rank-down="rankDown"></section-info>

        <div class="col-12 mb-4">
            <div class="wrapper-btns">
                <a href="#" class="btn btn-grisclair5 add-content" @click.prevent.stop="addSection">
                    Ajouter un contenu
                </a>
            </div>
        </div>

        <div class="col-12 mb-4">
            <x-forms.input-custom-switch
                    name="statut_id"
                    id="statut_id"
                    :checked="isset($page) ? $page->statut_id === 1 : false"
                    text="Actif"
                    doubleText="Inactif"
            />
        </div>

        <div class="col-12 mb-4">
            <div class="wrapper-editor">
                <x-forms.editor
                        name="mentions"
                        text="Mentions <em>(facultatif)</em>"
                        :value="isset($page) ? $page->mentions : ''"
                        form="admin"
                        format="mini"
                />
            </div>
        </div>
    </div>

    @if(!(empty($sites)))
        <h2>Liste des sites disponibles</h2>
        @if(count($sites) > 0)
            <div class="custom-control custom-checkbox select-all-div">
                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                       id="select-all-sites"
                       checked
                >
                <label class="custom-control-label" for="select-all-sites"> Tout sélectionner / désélectionner</label>
            </div>
        @endif
        @foreach($sites as $site)
            <div class="custom-control custom-checkbox">
                <input type="checkbox" name="site{{ $site->id }}" class="custom-control-input site-checkbox"
                       id="site{{ $site->id }}"
                       @if($page->exists())
                           @foreach($site_pages as $site_page)
                               {{ $site_page->id === $site->id ? 'checked' : '' }}
                           @endforeach
                       @else
                           checked
                        @endif
                >
                <label class="custom-control-label" for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
            </div>
        @endforeach
    @endif

    @isset($parent_id)
        <input type="hidden" name="parent_id" value="{{ $parent_id }}">
    @endisset

    <div class="wrapper-btn justify-content-center">
        <button class="btn-annuler btn btn-secondary mx-2" type="button" data-dismiss="modal">Annuler</button>
        <button class="btn-valider btn btn-grisclair5 btn-primary mx-2" type="submit">Valider</button>
    </div>
</form>

<script>
  const {createApp} = Vue;

  const sectionApp = createApp({
    components: {"section-info": SectionInfo},
    setup() {
      return {sections: window.Sections || []};
    },
    methods: {
      sortSections() {
        this.sections.sort((a, b) => a.rang - b.rang);
      },
      addSection() {
        this.sections.push(new Section(this.sections.length + 1));
      },
      removeSection(form) {
        const index = this.sections.indexOf(form);
        this.sections.splice(index, 1);
        this.sections.forEach((section, i) => {
          if (i >= index) section.rang--;
        });
        this.sortSections();
      },
      rankUp(form) {
        const index = this.sections.indexOf(form);
        this.sections[index - 1].rang++;
        form.rang--;
        this.sortSections();
      },
      rankDown(form) {
        const index = this.sections.indexOf(form);
        this.sections[index + 1].rang--;
        form.rang++;
        this.sortSections();
      },
    },
    mounted() {
      window.bindCkfinder();
    },
    // template: `
    //   <div>
    //     <button @click="addSection">Add Section</button>
    //     <div v-for="section in sections" :key="section.id">
    //       <section-info :section="section"/>
    //       <button @click="removeSection(section)">Remove</button>
    //       <button @click="rankUp(section)" :disabled="section.rang === 1">Move Up</button>
    //       <button @click="rankDown(section)" :disabled="section.rang === sections.length">Move Down</button>
    //     </div>
    //   </div>
    // `
  });
  sectionApp.mount("#whatEverModal #form");
</script>
