<?php

namespace Tests\Unit;

use Bloom\CMS\Modules\Architecture\Database\Relation\BelongsToPage;
use Bloom\CMS\Modules\Architecture\Database\Relation\HasExtendedRelationships;
use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Tests\Test;


/**
 * Class Contenu
 * @package Tests\Unit
 *
 * @property Page $page
 *
 *
 * @method static Builder|static published()
 * @method static Builder|static status(int $status)
 */
class Contenu extends Model implements \Bloom\CMS\Modules\Architecture\Model\Contenu
{
    use IsContenu;

    protected $guarded = [];

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }


    public function getHandler(): ContenuHandler
    {
        return new class extends Controller implements ContenuHandler {
            public function single(\Bloom\CMS\Modules\Architecture\Model\Contenu $contenu): Response
            {
                return \response([
                    "status" => true
                ]);
            }

            public function multiple(Collection $contenus): Response
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }
        };
    }
}

class PageTest extends Test
{
    public function getContenu(array $attributes = []): Contenu
    {
        Relation::morphMap([
            'contenus' => Contenu::class,
        ]);

        Page::declareContenu('contenus');

        /**
         * @var Page $page
         */
        $contenu = new Contenu();
        $contenu->html = 'test';
        $contenu->save();
        $attributes['contenu_type'] = 'contenus';
        $attributes['contenu_id'] = $contenu->id;
        $page = factory(Page::class)->create($attributes);
        $page->fill($attributes);
        $page->save();

        return $contenu;
    }

    public function test_eager_loading()
    {
        $this->getContenu([
            'pathname' => '/test'
        ]);
        $this->getContenu([
            'pathname' => '/test-2'
        ]);

        foreach (Contenu::with('page')->get() as $contenu) {
            static::assertNotNull($contenu->page);
        }
    }
}
