<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/03/20
 * Time: 14:56
 */

namespace Tests;


use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\View\Factory;
use Orchestra\Testbench\TestCase;
use TwigBridge\Facade\Twig;
use TwigBridge\ServiceProvider;

class Test extends TestCase
{

    use DatabaseTransactions;

    protected function getPackageProviders($app)
    {
        return [CmsArchiServiceProvider::class, ServiceProvider::class];
    }

    protected function getPackageAliases($app)
    {
        return [
            'Twig' => Twig::class
        ];
    }

    /**
     * Setup the test environment.
     */
    protected function setUp(): void
    {
        parent::setUp();
        $this->loadLaravelMigrations();
        $this->artisan('migrate', ['--database' => 'testing'])->run();
        // and other test setup steps you need to perform
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/testings/migrations');
        $this->seed(\StatutSeeder::class);
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('app.admin', 'admin');
        $app['config']->set('logging.default', 'stack');
        $app['config']->set('logging.channels.single.path', dirname(__DIR__) . '/logs/laravel.log');
        $app->afterResolving('view', function ($view) {
            /**
             * @var Factory $view
             */
            $view->addNamespace('Bloom', dirname(__DIR__) . '/resources/views_testing');
        });
    }
}