<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 31/07/2020
 * Time: 12:22
 */

use Bloom\Cms\Configuration\Facade\Site;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => [function($request, $next) {
	return $next($request)
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_MODULE', 'archi', 0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_L', ( null !== Site::value('VIGNETTE_ARCHI_IMG_L') ? Site::value('VIGNETTE_ARCHI_IMG_L') : 2000 ),0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_H', ( null !== Site::value('VIGNETTE_ARCHI_IMG_H') ? Site::value('VIGNETTE_ARCHI_IMG_H') : 1300 ),0, '/', null,null,false)) ; }]], function() {

	Route::get('/', 'AdminController@index')->name('index');
	Route::get('/{page}/publish', 'AdminController@publish')->name('publish');
	Route::get('/{page}/unpublish', 'AdminController@unpublish')->name('unpublish');
	Route::get('/{page}/archive', 'AdminController@archive')->name('archive');
	Route::get('/{page}/delete', 'AdminController@delete')->name('delete');
	Route::post('/{page}/move', 'AdminController@move')->name('move');
	Route::get('/{page}/move', 'AdminController@getFormMove')->name('move');
	Route::post('/dir/auto/{page?}', 'SommaireController@saveAuto')->name('auto_save');
	Route::post('/dir/perso/{page?}', 'SommaireController@savePerso')->name('perso_save');
	Route::get('/dir/{type}/{page?}', 'SommaireController@form')->name('som');

	//#region Section Miroir
	Route::get('/{miroir}/publishMiroir', 'AdminController@publishMiroir')->name('miroir_publish');
	Route::get('/{miroir}/unpublishMiroir', 'AdminController@unpublishMiroir')->name('miroir_unpublish');
	Route::get('/{miroir}/archiveMiroir', 'AdminController@archiveMiroir')->name('miroir_archive');
	Route::get('/{miroir}/deleteMiroir', 'AdminController@deleteMiroir')->name('miroir_delete');
	Route::post('/{page}/miroir', 'AdminController@miroir')->name('miroir');
	Route::get('/{page}/miroir', 'AdminController@getFormMiroir')->name('miroir');
	//#endregion

	//#region Section page_statiques
	Route::get('/statiques/{page}', 'StatiqueController@form')->name('edit_statique');
	Route::post('/statiques/{page}', 'StatiqueController@save')->name('save_statique');
	//#endregion

	//#region Histo Url
	Route::get('/historiques', 'AdminController@histo')->name('histo');
	//#endregion
});
