@extends('bloom.layout.admin')

@section('bodyClass', 'architecture page-listing')

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-archi')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    @include('ckfinder::setup')
@endsection

@section('modal')
    <div class="modal fade" id="whatEverModal" tabindex="-1" role="dialog" aria-labelledby="whatEverModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <p class="modal-title h5" id="whatEverModalLabel">Sommaire</p>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span class="bloomicon-admin-x" aria-hidden="true"></span>
                    </button>
                </div>
                <div class="modal-body"></div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Architecture</h1>
                <h2>Pages</h2>
            </div>

            <div class="btn-group dropleft">
                <button type="button" class="dropdown-dots dropdown-toggle" id="dropdownMenu"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <a href="#" class="btn btn-grisclair5 btn-primary">
                        Ajouter une page
                    </a>
                </button>
                <div class="dropdown-menu" aria-labelledby="dropdownMenu">
                    <div class="dropdown-item dropdown-elmt text text-white">
                        <span class="bloomicon-admin-folder"></span>
                        <span class="choix-title">Sommaire (nouveau répertoire)</span>
                        <ul class="choix-sommaire">
                            <li>
                                <a href="#" class="choix-sommaire-link" data-title="Créer un sommaire automatique"
                                   data-toload="{{ route('admin_archi_som','auto') }}" data-toggle="modal"
                                   data-target="#whatEverModal">Automatique</a>
                            </li>
                            <li>
                                <a href="#" class="choix-sommaire-link" data-title="Créer un sommaire personnalisé"
                                   data-toload="{{ route('admin_archi_som','perso') }}" data-toggle="modal"
                                   data-target="#whatEverModal">Personnalisé</a>
                            </li>
                        </ul>
                    </div>

                    @foreach($applicabilites as $applicabilite)
                        <a class="dropdown-item dropdown-elmt" href="{{ route($applicabilite->route) }}">
                            <span class="bloomicon-admin-github"></span>
                            <span class="text text-white">{{ $applicabilite->titre }}</span>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="content">
            <div class="nav-menus">
                <div class="section-archi entete">
                    <div class="pr-0 chemin-archi">Chemin</div>
                    <div class="pr-0 type-archi">Type de page</div>
                    <div class="pr-0 lien-archi">Lien menu</div>
                    <div class="pr-0 miroir-archi">Page miroir</div>
                    <div class="pr-0 btn-cta-archi col px-0"></div>
                </div>

                @foreach($pages as $page)
                    <x-modules.archi-section
                            :rang="1"
                            :page="$page"
                            :applicabilites="$applicabilites"
                    />
                @endforeach
            </div>
        </div>
    </div>
@endsection
