<?php


namespace Bloom\CMS\Modules\Architecture\Model;


use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Http\Response;
use Illuminate\View\View;

class Filtre extends Model implements Contenu
{

    public function page(): MorphToMany
    {
        return $this->morphToMany(Page::class, 'contenu', 'page_contenus');
    }

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                return \response();
            }

            public function multiple(Collection $contenus): Response
            {
                return \response();
            }

            public function ensemble()
            {
                return \response();
            }

            public function adminForm(Contenu $contenu = null): View
            {
                return \view('Archi::form_filtres', ['filtres' => Filtre::all(), 'valeur' => $contenu]);
            }

            /**
             * @inheritDoc
             */
            public function save(Contenu $contenu, array $attributes): bool
            {
                // Pas de modification du contenu de base
                return true;
            }
        };
    }
}