<?php

namespace Bloom\CMS\Modules\Alert;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Alert\Model\Alert;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\Relation;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use Twig\TwigFunction;
use Twig\TwigTest;
use TwigBridge\Facade\Twig;

class CmsAlertServiceProvider extends BloomProvider
{
    protected $nom = "Alert";
    protected $code = "alert";
    protected $icons = "file-text";

    public function boot(): void
    {
        parent::boot();

        // Déclaration contenu
        Relation::morphMap([
            'alerts' => Alert::class,
        ]);
        Page::declareContenu('alerts');

        $factory = new WorkflowsFactory(Alert::class);

        $this->declarePublishedWorkflow($factory);
        $this->declareProgrammedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);

        Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {

            public function getFunctions()
            {
                return [
                    new TwigFunction('alert', function (): Collection {
                        return Alert::published()->first();
                    })
                ];
            }


            /**
             * @inheritDoc
             */
            public function getGlobals()
            {
                $modal_alert = Alert::published()->first();

                if ($modal_alert) {
                    if ($modal_alert->one_time) {
                        $cookiealert = 'true';
                    } else {
                        $cookiealert = 'false';
                    }

                    return [
                        'modal_alert' => $modal_alert,
                        'cookiealert' => $cookiealert,
                    ];
                } else {
                    return [];
                }
            }
        });
    }

    public function declarePublishedWorkflow($factory)
    {
        $factory
            //#region ALERT_PUB
            ->add('Publiés', "ALERT_PUB")
            ->statement("SELECT alerts.*
                                    FROM alerts
                                    JOIN pages ON alerts.id = pages.contenu_id AND pages.contenu_type = 'alerts'
                                    WHERE pages.statut_id = " . Statut::PUBLIE ."
                                    LIMIT 1")
            ->edition('admin_alert_edit', 'Créer une alerte')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_alert_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_alert_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_alert_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_alert_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_alert_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }


    public function declareProgrammedWorkflow($factory)
    {
        $factory
            //#region ALERT_PROGRAMMED
            ->add('Programmés', "ALERT_PROGRAMMED")
            ->statement("SELECT alerts.*
                            FROM alerts
                            JOIN pages ON alerts.id = pages.contenu_id AND pages.contenu_type = 'alerts'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NOT NULL
                            ORDER BY pages.to_publish_at DESC")
            ->edition('admin_alert_edit', 'Créer une alerte')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_alert_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_alert_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_alert_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_alert_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_alert_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow($factory)
    {
        $factory
            //#region ALERT_EN_COURS
            ->add('En cours de rédaction', "ALERT_EN_COURS")
            ->statement("SELECT alerts.*
                                FROM alerts
                                JOIN pages ON alerts.id = pages.contenu_id AND pages.contenu_type = 'alerts'
                                WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NULL
                                ORDER BY updated_at DESC")
            ->edition('admin_alert_edit', 'Créer une alerte')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_alert_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_alert_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_alert_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_alert_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_alert_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region ALERT_ARCHIVED
            ->add('Archivés', "ALERT_ARCHIVED")
            ->statement("SELECT alerts.*
                                FROM alerts
                                JOIN pages ON alerts.id = pages.contenu_id AND pages.contenu_type = 'alerts'
                                WHERE pages.statut_id = " . Statut::ARCHIVE . "
                                ORDER BY updated_at DESC")
            ->edition('admin_alert_edit', 'Créer une alerte')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_alert_unpublish')
                    ->addAction('Supprimer', 'admin_alert_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_alert_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),                ]
            )
            ->push();
        //#endregion
    }
}
