@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit page-agence')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-agence')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
    <script>
      window.Equipes = {!! $agence->equipes !!};
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $agence->exists() ? 'Modifier' : 'Créer' }} une agence</h1>

            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_agence_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider btn btn-grisclair5 btn-primary"
                   onclick="submitAndLeave()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
                <a href="@if($agence->exists()){{ route('admin_agence_preview', $agence) }} @else javascript:void(0); @endif"
                   target="_blank" class="btn-previsualier btn btn-grisclair5 btn-primary"
                   title="Sauvegarder pour prévisualiser">
                    Prévisualiser
                </a>
            </span>
        </div>

        <div class="content">
            <form action="{{ route('admin_agence_save', $agence) }}" method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                :value="$page->titre"
                                form="admin"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                :value="$page->slug"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="vignette" class="control-label">Vignette</label>
                    <x-forms.input-custom-file-with-image
                            name="vignette"
                            text="Parcourir"
                            form="admin"
                            :required="true"
                            :value="$page->image_opengraph"
                    />
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="intro"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$page->intro"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="adresse"
                                    text="Adresse"
                                    :value="$agence->adresse"
                                    form="admin"
                                    format="mini"
                                    :max="10000"
                                    :required="true"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="novadial"
                                text="Identifiant Apenda"
                                :value="$agence->novadial"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-number
                                name="cp"
                                text="Code postal"
                                :value="$agence->cp"
                                placeholder=""
                                form="admin"
                                :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="ville"
                                text="Ville"
                                :value="$agence->ville"
                                form="admin"
                                :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-number
                                name="point_lat"
                                text="Latitude"
                                :value="$agence->point->lat"
                                placeholder=""
                                form="admin"
                                :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-number
                                name="point_lng"
                                text="Longitude"
                                :value="$agence->point->lng"
                                placeholder=""
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="mentions"
                                    text="Mentions <em>(facultatif)</em>"
                                    :value="$page->mentions"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="card b-0 mb-4">
                    <div class="card-header" id="headingOne">
                <span class="title-collapse d-block">
                    <a href="#" class="d-flex" role="button" data-toggle="collapse" data-target="#collapseOne"
                       aria-expanded="false" aria-controls="collapseOne">
                        <span class="text">Horaires</span>
                        <span class="bloomicon-admin-plus add" aria-hidden="true"></span>
                        <span class="bloomicon-admin-minus remove" aria-hidden="true"></span>
                    </a>
                </span>
                    </div>

                    <div id="collapseOne" class="collapse" aria-labelledby="heading01">
                        <div class="card-body p-0">
                            <div class="wrapper-exergue wrapper01-heading01">
                                @php
                                    $horaires = [
                                        ["Lundi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]],
                                        ["Mardi" =>  ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]],
                                        ["Mercredi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]],
                                        ["Jeudi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]],
                                        ["Vendredi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]],
                                        ["Samedi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]]
                                    ];
                                @endphp

                                @if($agence->exists())
                                    @php($horaires = $agence->horaires)
                                @endif

                                @foreach($horaires[0] as $name => $horaire)
                                    <div class="form-group row align-items-center @if(!$loop->first) mt-2 @endif mb-0">
                                        <div class="col-1">
                                            <label class="control-label text-gris4">{{ ucwords($name) }}</label>
                                        </div>

                                        <div class="col-5 wrapper-group{{ $loop->index }}-1">
                                            <div class="row justify-content-center align-items-center py-2">
                                                <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_01'"
                                                        :value="$horaire->debut_matin"
                                                        placeholder="de"
                                                        form="admin"
                                                />
                                                <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_02'"
                                                        :value="$horaire->fin_matin"
                                                        placeholder="à"
                                                        form="admin"
                                                />
                                            </div>
                                        </div>

                                        <div class="col-1">
                                            <label class="control-label text-gris4 justify-content-center align-items-center">et</label>
                                        </div>

                                        <div class="col-5 wrapper-group{{ $loop->index }}-2">
                                            <div class="row justify-content-center align-items-center py-2">
                                                <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_03'"
                                                        :value="$horaire->debut_am"
                                                        placeholder="de"
                                                        form="admin"
                                                />
                                                <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_04'"
                                                        :value="$horaire->fin_am"
                                                        placeholder="à"
                                                        form="admin"
                                                />
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card b-0 mb-4">
                    <div class="card-header" id="headingTwo">
                        <span class="title-collapse d-block">
                            <a href="#" class="d-flex" role="button" data-toggle="collapse" data-target="#collapseTwo"
                               aria-expanded="false" aria-controls="collapseTwo">
                                <span class="text">Équipe</span>
                                <span class="bloomicon-admin-plus add" aria-hidden="true"></span>
                                <span class="bloomicon-admin-minus remove" aria-hidden="true"></span>
                            </a>
                        </span>
                    </div>

                    <div id="collapseTwo" class="collapse" aria-labelledby="heading02">
                        <div class="card-body px-0 pb-0">
                            <div id="wrapper-equipe" class="list-equipe wrapper-exergue wrapper01-heading02 pb-0">
                                <section-equipe :key="personne.uuid" v-for="(personne, index) in equipes"
                                                v-model="equipes[index]"
                                                @modif="test" @remove="removeMember"></section-equipe>
                            </div>

                            <div class="wrapper-exergue">
                                <div class="form-group mt-1 mb-1 wrapper-btns">
                                    <a href="javascript:void(0);" class="add-membre btn btn-grisclair5 mr-0"
                                       data-title="Créer un membre d'équipe"
                                       data-toggle="modal" data-target="#whatEverModal">
                                        Ajouter un membre
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <input type="hidden" name="statut_id" value="{{ $page->statut_id }}">
                <input type="hidden" name="equipes" value="">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal membre-equipe what-ever-modal fade" id="whatEverModal" tabindex="-1" role="dialog"
         aria-labelledby="whatEverModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <p id="whatEverModalLabel" class="modal-title h5">Créer un membre d'équipe</p>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="javascript:void(0);" method="POST" id="whatEverFormModal"
                          enctype="multipart/form-data">
                        <div class="form-group row mb-0">
                            <div class="col-6 mb-4">
                                <div class="mt-0">
                                    <x-forms.input-text
                                            name="prenom"
                                            text="Prénom"
                                            value=""
                                            form="admin"
                                            :required="true"
                                            :icon="member.prenom"
                                    />
                                </div>
                                <div class="mt-4">
                                    <x-forms.input-text
                                            name="nom"
                                            text="Nom"
                                            value=""
                                            form="admin"
                                            :required="true"
                                            :icon="member.nom"
                                    />
                                </div>
                                <div class="mt-4">
                                    <x-forms.input-text
                                            name="fonction"
                                            text="Fonction"
                                            value=""
                                            form="admin"
                                            :required="true"
                                            :icon="member.fonction"
                                    />
                                </div>
                            </div>

                            <div class="col-6 mb-4">
                                <label for="photo" class="control-label">Photo (165x165px)<em>(facultatif)</em></label>
                                <x-forms.input-custom-file-with-image-vue
                                        name="photo"
                                        text="Parcourir"
                                        form="admin"
                                        :required="true"
                                        value=""
                                        :vmodel="member.image"
                                />
                            </div>
                        </div>

                        <div class="wrapper-btn justify-content-center">
                            <button class="btn-annuler btn btn-grisclair5 btn-primary mx-2" type="button"
                                    data-dismiss="modal">Annuler
                            </button>
                            <button class="btn-valider btn btn-grisclair5 btn-primary mx-2" type="submit"
                                    @click.prevent="changeMyMember">Valider
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection