<?php

namespace Bloom\CMS\Modules\Agences\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class Equipe
 * @package Bloom\CMS\Modules\Agences\Model
 *
 * @property integer $id
 * @property integer $agence_id
 * @property string  $nom
 * @property string  $prenom
 * @property string  $fonction
 * @property integer $rank
 * @property string  $image
 *
 *
 */
class Equipe extends Model
{

    protected $fillable = ['rank'];

    public function agence() : BelongsTo
    {
        return $this->belongsTo(Agence::class);
    }
}
