<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\Cms\Configuration\Facade\Site;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => [function($request, $next) {
	return $next($request)
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_MODULE', 'agence', 0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_L', ( null !== Site::value('VIGNETTE_AGENCE_IMG_L') ? Site::value('VIGNETTE_AGENCE_IMG_L') : 2000 ),0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_H', ( null !== Site::value('VIGNETTE_AGENCE_IMG_H') ? Site::value('VIGNETTE_AGENCE_IMG_H') : 1300 ),0, '/', null,null,false)) ; }]], function() {

	Route::get('/', 'AdminController@index')->name('index');
	Route::get('/encours', 'AdminController@encours')->name('encours');
	Route::get('/archived', 'AdminController@archived')->name('archived');
	Route::get('/edit/{agence?}', 'AdminController@edit')->name('edit');
	Route::post('/edit/{agence?}', 'AdminController@save')->name('save');
	Route::get('/{agence}/preview', 'AdminController@preview')->name('preview');
	Route::get('/{agence}/publish', 'AdminController@publish')->name('publish');
	Route::get('/{agence}/unpublish', 'AdminController@unpublish')->name('unpublish');
	Route::get('/{agence}/archive', 'AdminController@archive')->name('archive');
	Route::get('/{agence}/delete', 'AdminController@delete')->name('delete');
	Route::post('/reorder', 'AdminController@reorder')->name('reorder');

	// Routes Equipes
	Route::post('/{equipe_id}/deleteEquipe', 'AdminController@deleteEquipe')->name('admin_equipe_delete');

});
