<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Agences;

use Bloom\CMS\Modules\Agences\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Agences\Model\Agence;
use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsAgencesServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Agences');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-agences')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('agence')->firstOrCreate([
                'nom'        => 'agence',
                'nom_public' => 'Agences',
                'route'      => 'admin_agence_index',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }

            return $module;
        }

        return false;
    }

    public function boot(): void
    {

        // Déclaration contenu
        Relation::morphMap([
            'agences' => Agence::class,
        ]);
        Page::declareContenu('agences');
        self::getModule();

        //Création du dossier Agences si il n'existe pas
        if (Dossier::where('name', '=', "Réseau d'agences")->count() < 1) {
            $dossier = new Dossier();
            $dossier->name = "Réseau d'agences";
            $dossier->slug = 'réseau';
            $dossier->type = 'simple';
            $dossier->save();
        }

    }

}