<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */


namespace Bloom\CMS\Modules\Agences;

use Bloom\Cms\Configuration\Facade\Site;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Agences\Model\Agence;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Schema;

class CmsAgencesServiceProvider extends BloomProvider
{
    protected $nom = "Agences";
    protected $code = "agence";
    protected $has_admin = true;
    protected $icons = "map-pin";

    public const DOSSIER = "Réseau d'agences";

    public function boot(): void
    {
        parent::boot();

        Site::config('Largeur image agence', 'VIGNETTE_AGENCE_IMG_L', 'Agence', '0', '\d+', 'La largeur doit être un chiffre', false);
        Site::config('Largeur image agence', 'VIGNETTE_AGENCE_IMG_H', 'Agence', '0', '\d+', 'La largeur doit être un chiffre', false);

        // Déclaration contenu
        Relation::morphMap([
            'agences' => Agence::class,
        ]);
        Page::declareContenu('agences');

        //Création du dossier Agences si il n'existe pas
        if (Schema::hasTable('dossiers')) {
            if (Dossier::where('name', '=', self::DOSSIER)->count() < 1) {
                $dossier = new Dossier();
                $dossier->name = "Réseau d'agences";
                $dossier->slug = 'réseau';
                $dossier->type = 'simple';
                $dossier->save();
            }
        }
    }
}
