import slugify from 'slugify';
import Sortable from "sortablejs";
import sectionEquipe from './vue/sectionEquipe.vue';
import {createApp, reactive} from 'vue';

export const EventBus = createApp({});
export const store = reactive({
  equipes: []
});

export function setEquipes(newEquipes) {
  store.equipes = newEquipes.map((m) => ({...m, uuid: uuid()}));
}

function updateEquipes(newData) {
  window.Equipes = newData;
  setEquipes(newData);
}

export function addMembre(membre) {
  store.equipes.push({...membre, uuid: uuid()});
}

let form;
let loaded = false;
let membersToDelete = [];

function uuid() {
  var uuid = "", i, random;
  for (i = 0; i < 32; i++) {
    random = Math.random() * 16 | 0;

    if (i === 8 || i === 12 || i === 16 || i === 20) {
      uuid += "-"
    }
    uuid += (i === 12 ? 4 : (i === 16 ? (random & 3 | 8) : random)).toString(16);
  }
  return uuid;
}

window.publishAndSubmit = () => {
  form = $('.main form');
  // Si le form est pas présent c'est que jean michel click avant la fin du chargement de la page
  if (form === undefined) {
    document.addEventListener('readystatechange', publishAndSubmit);
  }

  let statut = form.find('input[name="statut_id"]').first();

  if (statut.length) {
    statut.val('1');
  } else {
    form.append($('<input name="statut_id" value="1" type="hidden">'));
  }

  membersToDelete.forEach(element => {
    if (element && element.id !== '') {
      axios.post('/admin/agence/' + element.id + '/deleteEquipe');
    }
  });

  membersToDelete = [];
  form.submit();
}

window.submitAndLeave = () => {
  membersToDelete.forEach(element => {
    if (element && element.id !== '') {
      axios.post('/admin/agence/' + element.id + '/deleteEquipe');
    }
  });
  membersToDelete = [];
  form.submit();

}

document.addEventListener("readystatechange", () => {
  /**
   * Block / Unblock link_choice
   * @param group
   * @param el
   */

  function timeChange(group, el) {
    $(group).find('input').prop('required', el.value !== '' ? true : false);
  }

  form = $('.main form');
  let timeElements = $('[class*="wrapper-group"]');

  if (timeElements.length > 0) {
    for (let i = timeElements.length - 1; i >= 0; i--) {
      timeElements[i].querySelectorAll('[name^="hour"]').forEach((el) => {
        $(el).change(function (e) {
          timeChange(timeElements[i], e.target);
        });
      });
    }
  }

  $('#titre').on('input', function (e) {
    $('#slug').val(slugify(e.target.value, {strict: true, remove: /\s[!.?]/g}))
  });

  if (!loaded) {
    loaded = true;

    let data = {
      agence_id: '',
      id: '',
      prenom: '',
      nom: '',
      fonction: '',
      image: '/images/photo_equipe_defaut.jpg'
    };
    const modalForm = createApp({
      data() {
        setEquipes(window.Equipes);
        return {
          member: {
            ...data,
            rank: store.equipes.length + 1
          },
          section: null,
          photo: data.image
        }
      },
      mounted() {
        EventBus.config.globalProperties.changeMember = this.changeMember;
        const $this = this;

        $("#whatEverModal").on('shown.bs.modal', function () {
          let el = $(document.getElementById('photo').dataset.target);
          let input = $(document.getElementById('photo'));
          let preview = $(document.getElementById('photo').dataset.preview);
          $('#photo').click(function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            CKFinder.modal({
              chooseFiles: true,
              onInit: function (finder) {
                finder.on("files:choose", function (e) {
                  let file = e.data.files.first();
                  el.val(file.getUrl()).change();
                  $this.changeImage(file.getUrl());
                });
                finder.on("file:choose:resizedImage", function (e) {
                  el.val(e.data.resizedUrl).change();
                });
              },
            });
          });
          el.change(function (e) {
            if (preview) {
              e.currentTarget.offsetParent.classList.add("full");
              preview.attr("src", el.val()).removeClass("no-value");
            }
          });
        });
      },
      watch: {
        photo: function (image) {
          this.member.image = image;
        }
      },
      methods: {
        changeImage(image) {
          this.member.image = image;
        },
        changeMember(section = null) {
          this.section = section;
          $('#whatEverFormModal').data('validator').resetForm();
          this.member = {
            ...{uuid: uuid()},
            ...data,
            rank: store.equipes.length + 1,
          };
          if (section && section.prenom) {
            this.member = {
              ...section
            };
          }
        },
        changeMyMember(member) {
          if (!$('#whatEverFormModal').valid()) {
            return false;
          } else {
            if (member.rank === store.equipes.length + 1) {
              addMembre(member)
            } else {
              for (let i in member) {
                if (this.section.hasOwnProperty(i)) {
                  this.section[i] = member[i];
                }
              }
              const index = store.equipes.findIndex(equipe => equipe.id === member.id);
              if (index !== -1) {
                this.equipes = Array.from(store.equipes).map((el) => {
                  return {...store.equipes[index], ...member};
                });
                updateEquipes(this.equipes);
              } else {
                console.error('Membre non trouvé');
              }
            }
            $('#whatEverModal').modal('hide');
            $("input[name='equipes']").val(JSON.stringify(store.equipes));
            this.member = {
              ...data,
              rank: store.equipes.length + 1
            };
            this.photo = data.image;
          }
        }
      }
    });
    modalForm.mount('#whatEverFormModal');

    const wrapperEquipe = createApp({
      components: {
        'section-equipe': sectionEquipe
      },
      setup() {
        setEquipes(window.Equipes);
        return {
          equipes: store.equipes
        }
      },
      mounted() {
        this.sortSections();

        $('body').delegate('[data-toggle="modal"]', 'click', (e) => {
          e.preventDefault();
          let titleModal = e.currentTarget.dataset.title;
          $('#whatEverModalLabel').text(titleModal);
        });

        let option = {
          handle: '.sortable-el',
          animation: 150,
          onUpdate: () => {
            const equipeElements = document.querySelectorAll('#wrapper-equipe .wrapper-equipe');
            this.equipes = Array.from(equipeElements).map((el, index) => {
              const id = parseInt(el.querySelector('.section-archi').getAttribute('data-id'));
              const equipe = store.equipes.find(e => e.id === id);
              return {...equipe, rank: index + 1};
            });
            updateEquipes(this.equipes);
            this.sortSections();
            $("input[name='equipes']").val(JSON.stringify(this.equipes));
          }
        };

        new Sortable(document.getElementById('wrapper-equipe'), {
            ...option,
            group: 'equipe',
            draggable: '> .wrapper-equipe'
          }
        );
      },
      methods: {
        sortSections: function () {
          this.equipes.sort((a, b) => {
            return a.rank - b.rank;
          });
          this.$forceUpdate();
        },
        removeMember(section) {
          membersToDelete.push(section);
          let newEquipe = [];
          for (let i = this.equipes.length - 1; i >= 0; i--) {
            if (this.equipes[i].id === section.id) {
            } else {
              newEquipe.push(this.equipes[i]);
            }
          }
          this.equipes = newEquipe.reverse();
          updateEquipes(this.equipes);
          this.sortSections();
          $("input[name='equipes']").val(JSON.stringify(this.equipes));
        },
        addMember() {
          EventBus.config.globalProperties.changeMember();
        },
        test(section) {
          EventBus.config.globalProperties.changeMember(section);
        }
      }
    });
    wrapperEquipe.mount('#wrapper-equipe');
  }
});
