<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEquipesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('equipes', function (Blueprint $table) {
            $table->id();
            $table->integer('agence_id', false, true);
            $table->string('nom', 100);
            $table->string('prenom', 100);
            $table->string('fonction', 100);
            $table->integer('rank');
            $table->string('image');
            $table->timestamps();

            $table->foreign(['agence_id'])->on('agences')->references('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('equipes');
    }
}
