@extends('bloom.layout.default')

@section('bodyClass', 'agence')

@section('content')
    <section class="b-gris7">
        <div class="container wrapper-content">
            <h1>{{ $page->titre }}</h1>

            @if(!is_null($page->intro))
                <div class="exergue">
                    <p>{!! $page->intro !!}</p>
                </div>
            @endif
        </div>

        <div class="container">
            <div class="wrapper-agence row">
                <div class="block-infos col-lg-4 col-md-5">
                    <div class="block-contact">
                        @if(isset($agence->novadial) && strlen($agence->novadial) > 0)
                            <a href="#"
                               onclick="document.dispatchEvent(new CustomEvent('form.open-modal', { detail: { view: 'form-novadial-particuliers', urlIframe: '{{ '?agency=' . $agence->novadial }}' } }));"
                               class="block-rdv mb-2">
								<span class="text text-right">
									<span class="material-icons-outlined">event</span>
									<strong class="d-block">Prendre rendez-vous</strong>
								</span>
                            </a>
                        @endif
                        <a href="tel:+33970828180" class="block-tel">
							<span class="text text-right">
								<span class="material-icons-outlined">phone</span>
								<strong class="d-block">0970 82 81 80</strong>
								<span class="d-block">appel non surtaxé</span>
							</span>
                        </a>
                    </div>

                    <div class="block-adresse">
                        {!! strip_tags($agence->adresse, '<br>') !!}<br>
                        {{ $agence->cp }}
                        <span class="text-uppercase">{{ $agence->ville }}</span>
                    </div>

                    <div class="block-horaires">
                        <p class="h2">
                            <strong>Horaires</strong>
                        </p>

                        <div class="table-responsive">
                            <table class="table-horaires w-100">
                                @foreach($agence->horaires as $day)
                                    @foreach($day as $name => $horaire)
                                        <tr>
                                            <th>{{ ucwords($name) }}</th>
                                            <td>
                                                @if(isset($horaire->debut_matin))
                                                    {{ $horaire->debut_matin }}
                                                    -
                                                    {{ $horaire->fin_matin }}
                                                @else
                                                    {{ ucwords('fermé') }}
                                                @endif
                                            </td>
                                            <td>
                                                @if(isset($horaire->debut_am))
                                                    {{ $horaire->debut_am }}
                                                    -
                                                    {{ $horaire->fin_am }}
                                                @else
                                                    {{ ucwords('fermé') }}
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            </table>
                        </div>
                    </div>
                </div>

                <div id="map-agence" class="col-lg-8 col-md-7">
                    <map-agence
                            :position='{lat: {{ $agence->point->lat }}, lng: {{ $agence->point->lng }} }'></map-agence>
                </div>
            </div>
        </div>
    </section>

    @php($rank = array_column($agence->equipes->toArray(), 'rank'))
    @php(array_multisort($rank, SORT_ASC, $agence->equipes->toArray()))
    @php($sortedEquipes = $agence->equipes)

    <section class="equipes bg-grisf b-grisd">
        <div class="container">
            <h1 class="text-center text-bleu">
                <span class="icon-equipe text-orange"></span>Notre équipe</h1>

            <ul class="list-unstyled listing-equipe row">
                @foreach($sortedEquipes as $personne)
                    <li class="col-lg-4 col-sm-6">
                        <div class="row">
						<span class="img col-6">
							<img src="{{ $personne->image }}" alt="" class="img-fluid">
						</span>
                            <div class="wrapper-person col-6">
                                <strong class="title">
                                    {{ ucwords($personne->prenom) }}
                                    {{ ucwords($personne->nom) }}
                                </strong>
                                <span class="desc">{{ $personne->fonction }}</span>
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>
    </section>

    @if(strlen($page->mentions) > 0)
        <section class="mentions b-gris7">
            <div class="container">
                <p>
                    <strong>Mentions</strong>
                </p>

                <div class="content">
                    {!! $page->mentions !!}
                </div>
            </div>
        </section>
    @endif
@endsection