@extends('bloom.layout.admin')

@section('bodyClass', 'page-listing page-agence')

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-agence')
@endsection

@php
    use \Carbon\Carbon;
@endphp

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>Agences</h1>

            <a href="{{ route('admin_agence_edit') }}" class="btn btn-grisclair5 btn-primary">
                Créer une agence
            </a>
        </div>

        <div class="content">
            <ul class="list-nav-articles nav nav-pills mb-3">
                @foreach($sub_menu_items as $item)
                    @if($item['active'])
                        @php($onglet = strtolower(str_replace('é', 'e', $item['title'])))
                    @endif
                    <li class="nav-item">
                        <a href="{{ $item['href'] }}" @if($item['active']) class="active" @endif>
                            <span class="text">{{ $item['title'] }}</span>
                            <span class="badge badge-primary badge-pill">{{ $item['number'] }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="table-responsive">
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Ordre</th>
                        <th scope="col">Vignette</th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'id') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=id&order=@if($order['item'] === 'id') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Id</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'titre') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=titre&order=@if($order['item'] === 'titre'){{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Titre</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'created_at') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=created_at&order=@if($order['item'] === 'created_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Créé le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'updated_at') sort-{{ $order['order'] }}@endif"
                               href="?orderBy=updated_at&order=@if($order['item'] === 'updated_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Modifié le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'to_publish_at') sort-{{ $order['order'] }}@endif"
                               href="?orderBy=to_publish_at&order=@if($order['item'] === 'to_publish_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">
                                    Dates de<br>
                                    publication
                                </span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col" colspan="2"></th>
                    </tr>
                    </thead>
                    <tbody id="sortable-wrapper" data-url="{{ route('admin_agence_reorder') }}">
                    @if(count($agences) > 0)
                        @foreach($agences as $agence)
                            <tr @if($onglet === 'publiees') class="sortable-section" @endif>
                                <td class="sortable-el">
                                    <span class="fa fa-arrows"></span>
                                    <span class="text">{{ $agence->rank + 1 }}</span>
                                </td>
                                <td><img src="{{ $agence->page->image_opengraph }}" alt="" class="img-fluid"></td>
                                <td class="id-agence">{{ $agence->id }}</td>
                                <td>{{ $agence->page->titre }}</td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom" title="{{ $agence->page->cree_par->name }}">
                                        {{ Carbon::parse($agence->page->created_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom"
                                          title="{{ $agence->page->deriere_modification_par->name }}">
                                        {{ Carbon::parse($agence->page->updated_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    @if(isset($agence->page->to_publish_at))
                                        <span class="tooltip-elmt d-inline-block">
                                            du {{ Carbon::parse($agence->page->to_publish_at)->format('d/m/Y') }}<br>
                                            au {{ Carbon::parse($agence->page->to_unpublish_at)->format('d/m/Y') }}
                                        </span>
                                    @endif
                                </td>
                                <td class="btn-group-cta btn-group-sm text-right">
                                    <x-action-list
                                            :actions="$actions"
                                            :item="$agence"
                                    />
                                </td>
                                @if(count($sub_actions) > 0)
                                    <td>
                                        <x-action-dropdown
                                                :id="'dropdownMenu0' . $loop->index"
                                                :actions="$sub_actions"
                                                :item="$agence"
                                        />
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
