<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Agences\Http\Controllers'], function () {
    Route::group(['prefix' => 'agences'], function () {
        Route::get('/', 'AdminController@index')->name('admin_agence_index');
        Route::get('/encours', 'AdminController@encours')->name('admin_agence_encours');
        Route::get('/archived', 'AdminController@archived')->name('admin_agence_archived');
        Route::get('/edit/{agence?}', 'AdminController@edit')->name('admin_agence_edit');
        Route::post('/edit/{agence?}', 'AdminController@save')->name('admin_agence_save');
        Route::get('/{agence}/preview', 'AdminController@preview')->name('admin_agence_preview');
        Route::get('/{agence}/publish', 'AdminController@publish')->name('admin_agence_publish');
        Route::get('/{agence}/unpublish', 'AdminController@unpublish')->name('admin_agence_unpublish');
        Route::get('/{agence}/archive', 'AdminController@archive')->name('admin_agence_archive');
        Route::get('/{agence}/delete', 'AdminController@delete')->name('admin_agence_delete');
        Route::post('/reorder', 'AdminController@reorder')->name('admin_agence_reorder');

        // Routes Equipes
        Route::post('/{equipe_id}/deleteEquipe', 'AdminController@deleteEquipe')->name('admin_equipe_delete');
    });
});