<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu\Model;

use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Http\Response;
use Illuminate\View\View;


/**
 * Class Article
 * @package Bloom\CMS\Modules\Articles\Model
 *
 *
 * @property string            nom
 * @property string            couleur
 * @property Page[]|Collection page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static status(int $status)
 */
class Categorie extends Model implements Contenu
{

    public function page(): MorphToMany
    {
        return $this->morphToMany(Page::class, 'contenu', 'page_contenus');
    }

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                dump($contenu);

                return response(view('default'));
            }

            public function multiple(Collection $contenus): Response
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }

            public function adminForm(Contenu $contenu = null): View
            {
                // TODO: Implement adminForm() method.
            }

            public function save(Contenu $contenu, array $attributes): bool
            {
                // TODO: Implement save() method.
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

}