@extends('bloom.layout.default')
@section('bodyClass', 'actu')

@section('content')
    <section class="wrapper-content b-gris7">
        <div class="container">
            <h1>{{ $page->titre }}</h1>
            @if(!(is_null($page->intro)))
                <div class="exergue mb-50">
                    <div>
                        {!! $page->intro !!}
                    </div>
                </div>
            @endif

            @if(!(is_null($page->image_opengraph)))
                <img src="{{ asset($page->image_opengraph) }}" alt="" class="img-fluid w-100 mb-50">
            @else
                <img src="https://fakeimg.pl/1200x675/F18E00/FFF/?text=img+placeholder" alt=""
                     class="img-fluid w-100 mb-50">
            @endif

            {!! $actualite->contenu !!}

            <div class="wrapper-btns">
                <a href="{{ url( $urlActualite ) }}" class="btn btn-bleu btn-all">
                    Toutes les actus
                </a>
            </div>
        </div>
    </section>

    @if(count($page->mentions) > 0)
        <section class="mentions b-gris7">
            <div class="container">
                <p>
                    <strong>Mentions</strong>
                </p>

                <div class="content">
                    {!! $page->mentions !!}
                </div>
            </div>
        </section>
    @endif
@endsection