<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\CMS\Modules\Actu\Model\Actu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'actus'], function () {
    Route::get('/maj/{numPage}/{filter?}', function ($numPage, $filter = null) {
        /**
         * @var Collection $actualites
         */
        $query = $filter ? Actu::published()->where('categorie_id', '=', $filter) : Actu::published();

        $actualites = $query->join('pages', function ($join) {
            $join->on('actus.id', '=', 'pages.contenu_id')
                ->where('pages.contenu_type', '=', 'actus');
        })
            ->join('categories', 'categories.id', '=', 'actus.categorie_id')
            ->latest('pages.to_publish_at')->paginate(4, ['*'], '', $numPage);

        return $actualites;

    })->name('actus_maj');

    Route::get('/{categorie}', 'FrontController@pageCategorie')->name('actus_cat');
});