import actus from './actus.vue';
import {createApp} from "vue";

document.addEventListener("DOMContentLoaded", () => {
  const BaseApp = createApp({
    components: {'actus': actus},
    data() {
      return {
        actus: [],
        loadData: true,
        page: 2,
        scrollY: 0
      };
    },
    updated() {
      document.documentElement.scrollTop = document.body.scrollTop = this.scrollY;
    },
    methods: {
      loadNext() {
        this.scrollCalc();
        const Loader = document.getElementById('loader-general');
        if (Loader != undefined) {
          Loader.style.display = 'block';
        }
        $.ajax({
          url: '/actus/maj/' + this.page,
          type: 'GET',
          success: (response) => {
            this.actus = this.actus.concat(response.data);
            this.page++;
            this.loadData = (response.total !== response.to);
          }
        }).then(() => {
          if (Loader != undefined) {
            Loader.style.display = 'none';
          }
        });
      },
      scrollCalc() {
        this.scrollY = window.scrollY;
      }
    }
  });
  BaseApp.mount('#wrapper-listing-actus');
});