<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Bloom\CMS\Modules\Actu\Model\Categorie;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Schema;


class CmsActuServiceProvider extends BloomProvider
{
    protected $nom = "Actualités";
    protected $code = "actu";
    protected $icons = "actualites";

    public function boot(): void
    {
        parent::boot();

        if (Schema::hasTable('page_statiques')) {
            (new \PageActualitesSeeder)->run();
        }

        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Listing',
                'route' => 'admin_actu_index',
            ]),
            new AdminMenu([
                'label' => 'Catégories',
                'route' => 'admin_actu_categories',
            ]),
        ]);
        // Déclaration contenu
        Relation::morphMap([
            'actus' => Actu::class,
            'categories' => Categorie::class,
        ]);
        Page::declareContenu('actus');
        Page::declareContenu('categories');
        $factory = new WorkflowsFactory(Actu::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareProgrammedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);
    }

    public function declarePublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region ACTU_PUB
            ->add('Publiés', "ACTU_PUB")
            ->statement("SELECT actus.*
                            FROM actus
                            JOIN pages ON actus.id = pages.contenu_id AND pages.contenu_type = 'actus'
                            WHERE pages.statut_id = " . Statut::PUBLIE . " ORDER BY actus.updated_at DESC")
            ->edition('admin_actu_edit', 'Créer une actu')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_actu_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_actu_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_actu_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_actu_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_actu_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom')),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareProgrammedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region ACTU_PROGRAMMED
            ->add('Programmés', "ACTU_PROGRAMMED")
            ->statement("SELECT actus.*
                            FROM actus
                            JOIN pages ON actus.id = pages.contenu_id AND pages.contenu_type = 'actus'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NOT NULL
                            ORDER BY pages.to_publish_at DESC")
            ->edition('admin_actu_edit', 'Créer une actu')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_actu_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_actu_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_actu_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_actu_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_actu_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom')),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region ACTU_EN_COURS
            ->add('En cours de rédaction', "ACTU_EN_COURS")
            ->statement("SELECT actus.*
                            FROM actus
                            JOIN pages ON actus.id = pages.contenu_id AND pages.contenu_type = 'actus'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NULL
                            ORDER BY pages.updated_at DESC")
            ->edition('admin_actu_edit', 'Créer une actu')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_actu_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_actu_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_actu_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_actu_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_actu_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom')),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region ACTU_ARCHIVED
            ->add('Archivés', "ACTU_ARCHIVED")
            ->statement("SELECT actus.*
                                FROM actus
                                JOIN pages ON actus.id = pages.contenu_id AND pages.contenu_type = 'actus'
                                WHERE pages.statut_id = " . Statut::ARCHIVE . "
                                ORDER BY pages.updated_at DESC")
            ->edition('admin_actu_edit', 'Créer une actu')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_actu_unpublish')
                    ->addAction('Supprimer', 'admin_actu_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_actu_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom')),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }
}
