import Sortable from "sortablejs";

require('spectrum-colorpicker2/src/spectrum');

let loaded = false;
document.addEventListener("readystatechange", () => {
    let url = $('.nav-menus').data('ordre-url');

    let option = {
        handle: '.sortable-el',
        animation: 150,
        onUpdate: function (event) {
            let el = $(event.from);
            // let section = el.find('> .section-archi');
            let items = [];
            el.find('> .sortable-section').each(function () {
                let el = $(this);
                let section = el.find('> .section-archi');
                items.push(section.data('catid'));
            });
            axios.post(url, {ordre: items});
        }
    };

    new Sortable($('.nav-menus.nav-cat-actus-actif').get(0), {
            ...option,
            group: 'primary',
            draggable: '> .nav-archi-primary'
        }
    );

    //Gestion du check actif
    $(".section-archi input[name='actif']").change(function (e) {
        e.stopImmediatePropagation();
        let check = $(this).prop('checked'),
            id = $(this).parents('.section-archi').data('catid'),
            route = 'categories/' + id;

        route += check ? '/publish' : '/unpublish';
        axios.get(route).then((response) =>{
            if (response.data.success)
                window.location.reload();
        });

    });

    window.bindColorPickerInModal = function bindColorPickerInModal(val = '') {
        $('.color-picker').spectrum({
            color: val,
            type: "component",
            palette: [
                [
                    '',
                    '#D36D94',
                    '#7D7578',
                    '#403C3E',
                    '#66A8CA'
                ]
            ],
            showPalette: true,
            showPaletteOnly: false,
            togglePaletteOnly: false,
            hideAfterPaletteSelect: false,
            showInput: true,
            showInitial: false,
            cancelText: "Annuler",
            chooseText: "Valider",
            clearText: "Effacer couleur sélectionnée",
            noColorSelectedText: "Aucune couleur sélectionnée",
            togglePaletteMoreText: "Plus",
            togglePaletteLessText: "Moins",
            allowEmpty: true
        });
    }

    function listenForm() {
        let formModal = document.getElementById('form');

        if (document.getElementsByClassName('color-picker').length > 0) {
            //#region Gestion color picker
            let el = document.getElementsByClassName('color-picker'),
                val = el[0].value;
            bindColorPickerInModal(val);
            //#endregion
        }
    }

    function showModal(currentTarget) {
        let el = $(currentTarget),
            id = el.parents('.section-cat-actus').data('catid') !== undefined ? '/' + el.parents('.section-cat-actus').data('catid') : '',
            route = 'categories/' + el.data('toload') + id,
            titleModal = el.data('title'),
            classModal = el.data('catmodale');

        axios.get(route).then((response) => {
            $('.modal').removeClass('modale-gestion modale-modif').addClass('modale-' + classModal);
            $('#whatEverModalLabel').text(titleModal);
            $('.modal-body').html(response.data)
            $('.modal').modal();
            listenForm();
        });
    }

    if (!loaded) {
        loaded = true;
        $('body').delegate('.show-modal', 'click', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            showModal(e.currentTarget);
        });

        $('.modal').on('shown.bs.modal', function (e) {
            if ($('.modal .table-admin tbody').length > 0) {
                new Sortable($('.table-admin tbody').get(0), {
                        ...option,
                        group: 'primary',
                        draggable: '.sortable-section'
                    }
                );
            }
        });

    }
});