<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu;

use Bloom\CMS\Modules\Actu\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsActuServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Actu');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-actus')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            return Module::nom('actu')->firstOrCreate([
                'nom'        => 'actu',
                'nom_public' => 'Actualités',
                'route'      => 'admin_actu_index',
                'active'     => 1
            ]);
        }

        return false;
    }

    public function boot(): void
    {

        // Déclaration contenu
        Relation::morphMap([
            'actus' => Actu::class,
        ]);
        Page::declareContenu('actus');
        self::getModule();
    }

}