<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\Cms\Configuration\Facade\Site;
use Illuminate\Support\Facades\Route;



Route::group(['middleware' => [function($request, $next) {
	return $next($request)
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_MODULE', 'actu', 0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_L', ( null !== Site::value('VIGNETTE_ACTU_IMG_L') ? Site::value('VIGNETTE_ACTU_IMG_L') : 2000 ),0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_H', ( null !== Site::value('VIGNETTE_ACTU_IMG_H') ? Site::value('VIGNETTE_ACTU_IMG_H') : 1300 ),0, '/', null,null,false)) ; }]], function() {

	// Route Actualités

	Route::get('/edit/{actu?}', 'AdminController@edit')->name('edit');
	Route::post('/edit/{actu?}', 'AdminController@save')->name('save');
	Route::get('/{actu}/preview', 'AdminController@preview')->name('preview');
	Route::get('/{actu}/publish', 'AdminController@publish')->name('publish');
	Route::get('/{actu}/unpublish', 'AdminController@unpublish')->name('unpublish');
	Route::get('/{actu}/archive', 'AdminController@archive')->name('archive');
	Route::get('/{actu}/duplicate', 'AdminController@duplicate')->name('duplicate');
	Route::get('/{actu}/delete', 'AdminController@delete')->name('delete');

	// Routes Catégories
	Route::prefix('categories')->group(function () {
	    Route::get('/', 'AdminController@categories')->name('categories');
	    Route::post('/edit/{categorie?}', 'AdminController@saveCategorie')->name('save_categorie');
	    Route::get('/{id}/publish', 'AdminController@publishCategorie')->name('publish_categorie');
	    Route::get('/{id}/unpublish', 'AdminController@unpublishCategorie')->name('unpublish_categorie');
	    Route::get('/{categorie}/delete', 'AdminController@deleteCategorie')->name('delete_categorie');
	    Route::get('/{type}/{id?}', 'AdminController@formCategorie')->name('form_categorie');
	    Route::post('/reorder', 'AdminController@reorderCategorie')->name('reorder_categorie');

	});
});
