<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategorie extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('couleur');
            $table->unsignedInteger('parent_id');
            $table->timestamps();
        });

        Schema::table('actus', function (Blueprint $table) {
            $table->unsignedInteger('categorie_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::table('actus', function (Blueprint $table) {
            $table->dropColumn('categorie_id');
        });
        Schema::dropIfExists('categories');
    }
}
