@extends('bloom.layout.admin')
@section('bodyClass', 'page-listing')

@section('assets')
    @vite('resources/js/listing-cat-actus.js', 'vendor/cms-module-actu')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Actualités</h1>
                <h2>Catégories</h2>
            </div>

            <span class="wrapper-btns ml-auto">
                <a href="#" class="show-modal btn-creer btn btn-grisclair5 btn-primary" data-title="Créer une catégorie"
                   data-catmodale="modif" data-toload="form_crea">
                    Créer une catégorie
                </a>
            </span>
        </div>

        <div class="content">
            <div class="nav-menus nav-cat-actus nav-cat-actus-actif mb-5"
                 data-ordre-url="{{ route('admin_actu_reorder_categorie') }}">
                <div class="section-archi entete">
                    <div class="pr-0 titre-archi col">Nom catégorie</div>
                    <div class="pr-0 actif-archi">Actif</div>
                    <div class="pr-0 btn-cta-archi"></div>
                </div>
                @foreach($categories as $categorie)
                    <div class="nav-archi-primary sortable-section">
                        <div
                            class="section-archi section-cat-actus section-primary page @if($categorie->page->statut_id > 1) section-cat-inactif @endif"
                            data-catid="{{ $categorie->id }}" data-rank="{{ $categorie->rank }}">
                            <span class="cat-color">
                                <span class="cat-color-item"
                                      style="background-color: {{ $categorie->couleur }};"></span>
                            </span>
                            <div class="titre-archi col">
                                <span class="sortable-el"></span>
                                <span class="text">{{ $categorie->nom }}</span>
                                <span
                                    class="badge badge-primary badge-pill bg-gris6">{{ count($categorie->actus) }}</span>
                            </div>
                            <div class="actif-archi">
                                <x-forms.input-custom-switch
                                    name="actif"
                                    :id="'actif-' . $categorie->id"
                                    :checked="$categorie->page->statut_id === 1"
                                    text="Actif"
                                    :required="false"
                                    :disabled="false"
                                    doubleText="Inactif"
                                />
                            </div>
                            <div class="btn-cta-archi">
                                <div class="btn-group-cta btn-group-sm text-right">
                                    <a href="#" class="show-modal btn btn-cta btn-grisclair5 mr-1"
                                       data-title="Modifier la catégorie" data-catmodale="modif"
                                       data-toload="form_crea">
                                        Modifier
                                    </a>

                                    <a href="{{ route('admin_actu_delete_categorie', $categorie)}}"
                                       class="btn btn-cta btn-grisclair5 mr-0">
                                        Supprimer
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal modal-cat-actus fade" id="whatEverModal" tabindex="-1" role="dialog"
         aria-labelledby="whatEverModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <p class="modal-title h5" id="whatEverModalLabel">Créer une catégorie</p>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span class="bloomicon-admin-x" aria-hidden="true"></span>
                    </button>
                </div>
                <div class="modal-body"></div>
            </div>
        </div>
    </div>
@endsection
