import actus from './actus.vue';

const Vue = require('vue');

document.addEventListener("DOMContentLoaded", () => {
    new Vue({
        el: '#wrapper-listing-actus',
        components: { 'actus' : actus },
        data() {
            return {
                actus: [],
                loadData: true,
                page: 2
            };
        },
        methods: {
            loadNext() {
                let loader = document.getElementById('loader-general');
                if (loader != undefined) {
                    loader.style.display = 'block';
                }
                $.ajax({
                    url: '/actus/maj/' + this.page,
                    type: 'GET',
                    success: (response) => {
                        this.actus = this.actus.concat(response.data);
                        this.page++;
                        this.loadData = (response.total !== response.to);
                    }
                }).then(() => {
                    if (loader != undefined) {
                        loader.style.display = 'none';
                    }
                });
            }
        }
    });
});