<?php

use Bloom\CMS\Core\Contenus\Statut;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PageActualitesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //#region Actualités
        if (!DB::table('page_statiques')
            ->where('controller', 'Bloom\CMS\Modules\Actu\Http\Controllers\FrontController@index')->exists()) {
            $id = DB::table('page_statiques')->insertGetId([
                'controller'   => 'Bloom\CMS\Modules\Actu\Http\Controllers\FrontController@index',
                'display_type' => 'Actualites',
                'action' => 'Gérer les actualités',
                'route' => 'admin_actu_index'
            ]);
            $page = new \Bloom\CMS\Core\Http\Page();
            $page->titre = 'Actualités';
            $page->meta_titre = 'Actualités';
            $page->meta_description = '';
            $page->slug = 'actualites';
            $page->pathname = '/actualites';
            $page->intro = "<p>Ceci est l'intro de la page Actualités</p>";
            $page->mentions = "<p>Ici les mentions légales de la page Actualités</p>";
            $page->multiplicity = '1';
            $page->to_publish_at = now();
            $page->statut_id = Statut::PUBLIE;
            $page->created_by = 1;
            $page->last_modified_by = 1;
            $page->image_opengraph = null;
            $page->contenu_type = 'page_statiques';
            $page->contenu_id = $id;
            $page->save();
        }
        //#endregion
    }
}
