<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\{Builder, Collection, Model};
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Log;


/**
 * Class Actu
 * @package Bloom\CMS\Modules\Actu\Model
 *
 *
 * @property string            contenu
 * @property int               categorie_id
 * @property Page[]|Collection page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static programmed()
 * @method static Builder|static notProgrammed()
 * @method static Builder|static programmedFor(Carbon $date)
 * @method static Builder|static status(int $status)
 */
class Actu extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;
                $breadcrumbElements = [
                    ["name" => $page->titre, 'url' => ''],
                    ["name" => 'Actualités', 'url' => 'actualites']
                ];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(
                    view(
                        'Actu::front.index',
                        ['actualite' => $contenu, 'page' => $page, 'breadcrumbElements' => $breadcrumbElements]
                    )
                );
            }

            public function multiple(Collection $contenus): Response
            {
                Log::warning('multiple actualite not unhandled', ['contenu' => $contenus]);

                return \response();
            }

            public function ensemble()
            {
                Log::warning('ensemble actualite not unhandled');
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', 2);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }

    public function categorie()
    {
        return $this->belongsTo(Categorie::class);
    }

}