<?php
/**
 * Created by : jerome
 * Created at : 07/01/2021
 *
 * In : PhpStorm
 */

namespace Bloom\CMS\Modules\Actu\Http\Controllers;


use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Bloom\CMS\Modules\Actu\Model\Categorie;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;


class FrontController extends Controller
{
    public function index(Page $page)
    {
        /**
         * @var Collection $actualites
         */
        $actualites = Actu::published()->join('pages', function ($join) {
            $join->on('actus.id', '=', 'pages.contenu_id')
                ->where('pages.contenu_type', '=', 'actus');
        })
            ->latest('pages.to_publish_at')->paginate(4);

        /**
         * @var Collection $categories
         */
        $categories = Categorie::published()->get();

        $breadcrumbElements = [["name" => 'Actualités', 'url' => '']];
        $dossier = $page->dossier;
        while ($dossier !== null) {
            $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
            $dossier = $dossier->parent;
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        return view('Actu::front.listing', compact('actualites', 'breadcrumbElements', 'categories', 'page'));
    }
}