<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

// Route Actualités

Route::get('/edit/{actu?}', 'AdminController@edit')->name('edit');
Route::post('/edit/{actu?}', 'AdminController@save')->name('save');
Route::get('/{actu}/preview', 'AdminController@preview')->name('preview');
Route::get('/{actu}/publish', 'AdminController@publish')->name('publish');
Route::get('/{actu}/unpublish', 'AdminController@unpublish')->name('unpublish');
Route::get('/{actu}/archive', 'AdminController@archive')->name('archive');
Route::get('/{actu}/delete', 'AdminController@delete')->name('delete');

// Routes Catégories
Route::prefix('categories')->group(function () {
    Route::get('/', 'AdminController@categories')->name('categories');
    Route::post('/edit/{categorie?}', 'AdminController@saveCategorie')->name('save_categorie');
    Route::get('/{id}/publish', 'AdminController@publishCategorie')->name('publish_categorie');
    Route::get('/{id}/unpublish', 'AdminController@unpublishCategorie')->name('unpublish_categorie');
    Route::get('/{categorie}/delete', 'AdminController@deleteCategorie')->name('delete_categorie');
    Route::get('/{type}/{id?}', 'AdminController@formCategorie')->name('form_categorie');
    Route::post('/reorder', 'AdminController@reorderCategorie')->name('reorder_categorie');

});
