<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Actu\Http\Controllers'], function () {
    Route::group(['prefix' => 'actus'], function () {
        Route::get('/', 'AdminController@index')->name('admin_actu_index');
        Route::get('/programmed', 'AdminController@programmed')->name('admin_actu_programmes');
        Route::get('/encours', 'AdminController@encours')->name('admin_actu_encours');
        Route::get('/edit/{actu?}', 'AdminController@edit')->name('admin_actu_edit');
        Route::post('/edit/{actu?}', 'AdminController@save')->name('admin_actu_save');
        Route::get('/{actu}/preview', 'AdminController@preview')->name('admin_actu_preview');
        Route::get('/{actu}/publish', 'AdminController@publish')->name('admin_actu_publish');
        Route::get('/{actu}/unpublish', 'AdminController@unpublish')->name('admin_actu_unpublish');
        Route::get('/{actu}/delete', 'AdminController@delete')->name('admin_actu_delete');
    });
});