import {defineConfig} from "vite";
import laravel from "laravel-vite-plugin";
import vue from "@vitejs/plugin-vue";
import path from "path";
import {fileURLToPath, URL} from "node:url";
import {globSync} from "glob";

let inputs = globSync("resources/js/*.js", {});

console.log(inputs)

export default defineConfig({
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./resources', import.meta.url)),
      '@public': fileURLToPath(new URL('./public', import.meta.url)),
      "@spectrum-colorpicker2": path.resolve(
        __dirname,
        "node_modules/spectrum-colorpicker2/"
      ),
      vue: 'vue/dist/vue.esm-bundler.js'
    },
  },
  plugins: [
    laravel({
      input: inputs,
      refresh: ["resources/**", "src/**", "app/**", "routes/**"],
    }),
    vue({
      template: {
        transformAssetUrls: {
          // The Vue plugin will re-write asset URLs, when referenced
          // in Single File Components, to point to the Laravel web
          // server. Setting this to `null` allows the Laravel plugin
          // to instead re-write asset URLs to point to the Vite
          // server instead.
          base: null,

          // The Vue plugin will parse absolute URLs and treat them
          // as absolute paths to files on disk. Setting this to
          // `false` will leave absolute URLs un-touched so they can
          // reference assets in the public directory as expected.
          includeAbsolute: false,
        },
      },
    }),
  ],
});