<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu;

use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Bloom\CMS\Modules\Actu\Model\Categorie;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Schema;


class CmsActuServiceProvider extends BloomProvider
{
    protected $nom = "Actualités";
    protected $code = "actu";
    protected $icons = "actualites";

    public function boot(): void
    {
        parent::boot();

        if (Schema::hasTable('page_statiques')) {
            (new \PageActualitesSeeder)->run();
        }

        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Listing',
                'route' => 'admin_actu_index',
            ]),
            new AdminMenu([
                'label' => 'Catégories',
                'route' => 'admin_actu_categories',
            ]),
        ]);
        // Déclaration contenu
        Relation::morphMap([
            'actus' => Actu::class,
            'categories' => Categorie::class,
        ]);
        Page::declareContenu('actus');
        Page::declareContenu('categories');
    }
}
