@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-actu')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($actu) ? 'Éditer' : 'Créer' }} une actu</h1>

            <span class="wrapper-btns ml-auto">
        <a href="{{ route('admin_actu_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
            Annuler
        </a>
        <a href="javascript:void(0);" class="btn-valider btn btn-grisclair5 btn-primary"
           onclick="$('.main form').submit()">
            Valider
        </a>
        <a href="javascript:void(0);" class="btn-publier btn btn-grisclair5 btn-primary" onclick="publishAndSubmit()">
            Valider et publier
        </a>
        <a href="@if(isset($article)) {{ route('admin_actu_preview', $article) }} @else javascript:void(0); @endif"
           target="_blank"
           class="btn-previsualier btn btn-grisclair5 btn-primary @if(!(isset($article))) disabled @endif"
           title="@if(!(isset($article))) Sauvegarder pour prévisualiser @endif">
            Prévisualiser
        </a>
    </span>
        </div>

        <div class="content">
            <form action=" {{ route('admin_actu_save', $actu) }} " method="POST" id="form">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                form="admin"
                                :value="$page->titre"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                form="admin"
                                :value="$page->slug"
                        />
                    </div>

                    @if($categoryIsActive)
                        <div class="col-6 mb-4">
                            <x-forms.select
                                    name="categorie_id"
                                    text="Catégorie"
                                    form="admin"
                                    :value="$actu->categorie_id"
                                    :var="$categories"
                                    key="id"
                                    val="nom"
                                    textInside=""
                                    :disabled="count($categories) <= 0"
                            />
                        </div>
                    @endif

                    <div class="col-12 mb-4">
                        <label for="image" class="control-label">Image (Largeur max : 1140px)</label>
                        <x-forms.input-custom-file-with-image
                                name="vignette"
                                text="Parcourir"
                                form="admin"
                                :required="true"
                                :value="$page->image_opengraph"
                        />
                    </div>

                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="admin"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$page->intro"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="contenu"
                                    text="Contenu"
                                    :value="$actu->contenu"
                                    form="admin"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="mentions"
                                    text="Mentions <em>(facultatif)</em>"
                                    :value="$page->mentions"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>

                    <div class="row w-75">
                        <x-forms.input-calendrier
                                id="actu"
                                nameDebut="date_pub"
                                nameFin="date_depub"
                                :content="$page"
                        />
                    </div>
                </div>

                <input type="hidden" name="statut_id" value="{{ $page->statut_id }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
