@extends('bloom.layout.default')
@section('bodyClass', 'actualite')

@php
    use Carbon\Carbon;
@endphp

@section('head')
    @parent
    @vite('resources/js/actus.js', 'vendor/cms-module-actu')
    {{--    <script src="{{ mix('/actus.js', 'vendor/cms-module-actu') }}"></script>--}}
@endsection

@section('content')
    <section id="wrapper-listing-actus" class="wrapper-listing">
        <div class="container wrapper-content">
            <h1>Liste des actualités</h1>
        </div>

        <div id="listing-actus" class="list-unstyled list-actus">
            @foreach($actualites as $actualite)
                <div class="actu-item {{ $loop->index%2 === 0 ? 'bg-grisf' : 'bg-grisd' }}">
                    <div class="container">
                        <div class="row{{ $loop->index%2 === 0 ? '' : ' row-reverse' }}">
                            <span class="img col-md-6">
                                <img src="{{ asset($actualite->image_opengraph) }}" alt="" class="img-fluid w-100">
                            </span>

                            <div class="content col-md-6">
                                <strong class="title">
                                    {{ $actualite->titre }}
                                    <span class="date-pub">Publication le {{ Carbon::parse($actualite->updated_at)->format('d/m/Y') }}</span>
                                </strong>
                                <div class="desc">
                                    {!! $actualite->intro !!}
                                </div>
                                <div class="wrapper-btns">
                                    <a href="{{ $actualite->pathname }}" class="btn btn-link">
                                        Lire la suite
                                        <span class="material-icons-outlined">
                                            <span class="rotate-me">add_circle_outline</span>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach

            <actus :actus="actus"></actus>
        </div>

        @if(isset($actualites) && $actualites->lastPage() > $actualites->currentPage())
            <div class="wrapper-btn justify-content-center">
                <a href="javascript:void(0);" class="btn btn-bleu btn-all w-auto" @click.prevent="loadNext"
                   v-if="loadData">
                    Afficher les actualités suivantes
                </a>
            </div>
        @endif
    </section>
@endsection