<form action="{{ route('admin_actu_save_categorie', $categorie) }}" method="POST" id="form">
    {{ csrf_field() }}

    <div class="form-group mb-4">
        <x-forms.input-text
                name="nom"
                text="Nom de la categorie"
                form="admin"
                :value="$categorie->nom"
        />
    </div>

    <div class="form-group row mb-0">
        <div class="col-6 mb-4">
            <x-forms.input-custom-switch
                    name="actif"
                    :id="'actif-' . $categorie->id"
                    :checked="$categorie->page->statut_id === 1"
                    text="Actif"
                    :required="false"
                    :disabled="false"
                    doubleText="Inactif"
            />
        </div>

        <div class="col-6 mb-4">
            <x-forms.input-custom-control-picker
                    name="couleur"
                    text="Couleur"
                    :value="$categorie->couleur"
                    form="admin"
                    :required=true
                    :disabled=false
            />
        </div>
    </div>

    <div class="wrapper-btn justify-content-center">
        <button class="btn-annuler btn btn-secondary mx-2" type="button" data-dismiss="modal">Annuler</button>
        <button class="btn-valider btn btn-grisclair5 btn-primary mx-2" type="submit">Valider</button>
    </div>
</form>