<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;

/**
 * Class Article
 * @package Bloom\CMS\Modules\Articles\Model
 *
 *
 * @property string            nom
 * @property string            couleur
 * @property int               rank
 * @property Page[]|Collection page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static notdeleted()
 * @method static Builder|static status(int $status)
 * @method static Builder|static countactus()
 */
class Categorie extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                /**
                 * @var Collection $actualites
                 */
                $actualites = Actu::published()->join('pages', function ($join) {
                    $join->on('actus.id', '=', 'pages.contenu_id')
                        ->where('pages.contenu_type', '=', 'actus');
                })
                    ->where('categorie_id', '=', $contenu->id)
                    ->latest('pages.to_publish_at')->paginate(4);

                /**
                 * @var Collection $categories
                 */
                $categories = Categorie::published()->get();

                $breadcrumbElements = [["name" => 'Actualités', 'url' => 'actualites']];
                $breadcrumbElements[] = ["name" => $contenu->nom, 'url' => ''];

                return response(
                    view(
                        'Actu::front.listing',
                        compact('actualites', 'breadcrumbElements', 'categories')
                    )
                );

            }

            public function multiple(Collection $contenus): Response
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }

    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeNotdeleted(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->where('statut_id', '!=', 3);
        });
    }

    public function scopeCountactus()
    {
        return $this->actus()->count();
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function actus()
    {
        return $this->hasMany(Actu::class);
    }
}
