<?php

use Bloom\CMS\Modules\Actu\Model\Actu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class PageActuMorph extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $actus = Actu::all();

        foreach ($actus as $actu) {
            /**
             * @var Page $page
             */
            $page = Page::find($actu->page_id);
            if($page) {
                $page->contenu()->associate($actu);
                $page->save();
            }
        }

        Schema::table('actus', function (Blueprint $table) {
            $table->dropColumn('page_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('actus', function (Blueprint $table) {
            $table->integer('page_id', false, true);
        });
    }
}
