<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Actu\Model;

use Bloom\CMS\Modules\Architecture\Contenus\Contenu;
use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\{Builder, Collection, Model};
use Illuminate\Http\Response;


/**
 * Class Actu
 * @package Bloom\CMS\Modules\Actu\Model
 *
 *
 * @property string            contenu
 * @property Page[]|Collection page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static programmed()
 * @method static Builder|static notProgrammed()
 * @method static Builder|static programmedFor(Carbon $date)
 * @method static Builder|static status(int $status)
 */
class Actu extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;
                $breadcrumbElements = [["name" => $page->titre, 'url' => $page->slug]];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(view('Actu::front.index', ['actualite' => $contenu, 'page' => $page, 'breadcrumbElements' => $breadcrumbElements]));
            }

            public function multiple(Collection $contenus): Response
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                $actualites = Actu::published()->with('page')->get()->sortByDesc('page.to_publish_at');

                $breadcrumbElements = [["name" => 'Actualité', 'url' => 'actualites']];

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(view('Actu::front.listing', compact('actualites', 'breadcrumbElements')));
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', 2);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }

}