<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 27/06/2016
 * Time: 15:05
 */

namespace Bloom\Modules;

use Assetic\Factory\AssetFactory;
use Bloom\Framework\Application;
use Bloom\Framework\Assetics\NamespaceAwareAssetFactory;
use Bloom\Framework\Controllers\BModules;

class TestModules extends BModules
{
    public function getFactory()
    {
        $base_dir = dirname(dirname(dirname(__DIR__)));
        $asset = new NamespaceAwareAssetFactory($base_dir.'/module/test');
        $asset->addNamespace('Test', $base_dir.'/module/test');
        return $asset;
    }

    public function __construct(Application $parent)
    {
        parent::__construct($parent);
        $this->name = 'Un module de test';
        $this->scope = '';
        $this->url = '/test';
    }

    public function getViewPath()
    {
        return ['Test'=>dirname(dirname(dirname(__DIR__))).'/module/test'];
    }
}
