<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 20/06/2016
 * Time: 17:06
 */

namespace Bloom\Framework\Command;

use Assetic\AssetWriter;
use Assetic\Extension\Twig\TwigFormulaLoader;
use Assetic\Extension\Twig\TwigResource;
use Assetic\Factory\LazyAssetManager;
use Bloom\Framework\Application;
use Bloom\Framework\Modules;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Symfony\Component\Console\Question\Question;

class InstallCommand extends Command
{
    protected function configure()
    {
        $this
            ->setName('module:install')
            ->setDescription('Install un module')
            ->addArgument(
                'module',
                InputArgument::REQUIRED,
                'Nom du module a installer'
            )
            ->addOption(
                'update',
                'u',
                InputOption::VALUE_NONE,
                'Si indiquer alors on update le module demander'
            )
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $module = $input->getArgument('module');
        chdir(BASE_PATH);
        putenv('PATH='.$_SERVER['PATH']);
        if (!$input->getOption('update')) {
            exec('composer require bloom/'.$module);
        } else {
            exec('composer update');
        }

        $question = new ChoiceQuestion('Où le module doit-il être installer', ['Front', 'Back']);
        $app = $this->getHelper('question')->ask( $input, $output,$question);

        $question = new Question('Indiquez le fullname de la class module : ');
        $nom = $this->getHelper('question')->ask($input, $output,$question);

        /**
         * @var Modules $module
         */
        if (class_exists($nom)) {
            if($app === 'Front') {
                $parent = Application::getInstance();
            } else {
                $parent = \Bloom\Cms\Application::getInstance();
            }
            $module = new $nom($parent);
        } else {
            $output->writeln("<error>La classe {$nom} n'a pas été trouvé</error>");
            return;
        }
        /**
         * @var Application $parent
         */
        $factory = $module->getFactory();

        if ($factory === null) {
            $output->writeln('Ok');
            return;
        }
        $parent->registerModules($module);
        $am = new LazyAssetManager($factory);

        $am->setLoader('twig', new TwigFormulaLoader($parent->getTwig()));
        foreach($module->getViewPath() as $template)
        {
            $resource = new TwigResource($parent->getLoader(), $template);
            $am->addResource($resource, 'twig');
        }
        $writer = new AssetWriter(APP_PATH);
        $writer->writeManagerAssets($am);
    }
}
