<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 11/05/2016
 * Time: 15:25
 */

namespace Bloom\Framework\View;

use Bloom\Framework\Application;

abstract class BView
{
    /**
     * @var string
     */
    protected static $name = 'default';
    public static $parameter = '[/]';
    /**
     * @var array
     */
    public $scripts = [];
    /**
     * @var array
     */
    public $styles = [];
    /**
     * @var array
     */
    protected $data = [];

    public function __construct()
    {
        $this->set('page', static::$name);
    }

    /**
     * @param string $tpl
     * @return string
     */
    public function display($tpl = '')
    {
        foreach($_SESSION[APP_NAME][APP_ENV] as $key=>$value) {
            $this->set($key,$value);
        }
        $this->set('me', $this);
        $this->set('modules', Application::$modules);
        $this->set('user', Application::getSession('current_user'));
        $this->set('errors', $_SESSION[APP_NAME][APP_ENV]['error']);
        return Application::renderS(static::$name.($tpl !== ''?'_'.$tpl:'').'.twig',$this->data);
    }

    /**
     * @param string $var
     * @param mixed $value
     */
    public function set($var, $value)
    {
        $this->data[$var] = $value;
    }


    /**
     * @param $script
     * @param string $path
     */
    public function addScript($script, $path = '')
    {
        if($path === '') {
            if (!defined('SCRIPT_PATH')) {
                throw new \InvalidArgumentException('Constant SCRIPT_PATH must be declared');
            }
            $path = SCRIPT_PATH;
        }
        $this->scripts[$script] = $path.'/'.$script;
    }

    /**
     * @param $stylesheet
     * @param string $path
     */
    public function addStyle($stylesheet, $path = '')
    {
        if($path === '') {
            if (!defined('STYLE_PATH')) {
                throw new \InvalidArgumentException('Constant STYLE_PATH must be declared');
            }
            $path = STYLE_PATH;
        }
        $this->styles[$stylesheet] = $path.'/'.$stylesheet;
    }

    public function setParameter(array $parameter)
    {
        $this->data = array_merge($this->data, $parameter);
    }
}
